USE AgencjaArtystycznaZmiana;
GO
CREATE PROCEDURE R15_przelicz_wartosci_kontraktow
AS 
UPDATE  Imprezy
SET        WartoscKontraktu = ROUND(1.15 * (DateDiff(d, DzienRozpoczecia, DzienZakonczenia) + 1) *
             (SELECT     StawkaDziennaWykonawcy
              FROM          Wykonawcy
              WHERE      Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy), 0);
GO

CREATE VIEW R15_przelicz_wartosci_kontraktow_zapytanie
AS 
SELECT NumerImprezy, DzienRozpoczecia, DzienZakonczenia, WartoscKontraktu, ROUND(1.15 * (DateDiff(d, DzienRozpoczecia, DzienZakonczenia) + 1) *
             (SELECT     StawkaDziennaWykonawcy
              FROM          Wykonawcy
              WHERE      Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy), 0)
AS NowaWartoscKontraktu, IDWykonawcy
FROM Imprezy;
GO

CREATE PROCEDURE R15_znizka_dla_dobrych_klientow_z_pazdziernika
AS 
UPDATE    Imprezy
SET              WartoscKontraktu = ROUND(WartoscKontraktu * 0.98, 0)
WHERE     (IDKlienta IN
              (SELECT     Imprezy.IDKlienta
               FROM          Imprezy
               WHERE      (Imprezy.DzienRozpoczecia <= '10/31/2017') 
                 AND (Imprezy.DzienZakonczenia >= '10/1/2017')
               GROUP BY Imprezy.IDKlienta
               HAVING      SUM(Imprezy.WartoscKontraktu) > 3000));
GO

CREATE VIEW R15_znizka_dla_dobrych_klientow_z_pazdziernika_zapytanie
AS 
SELECT      WartoscKontraktu, ROUND(WartoscKontraktu * 0.98, 0) AS NowaWartoscKontraktu
FROM Imprezy 
WHERE     (IDKlienta IN
              (SELECT     Imprezy.IDKlienta
               FROM          Imprezy
               WHERE      (Imprezy.DzienRozpoczecia <= '10/31/2017') 
                 AND (Imprezy.DzienZakonczenia >= '10/1/2017')
               GROUP BY Imprezy.IDKlienta
               HAVING      SUM(Imprezy.WartoscKontraktu) > 3000)) ;
GO

CREATE PROCEDURE R15_daj_agentom_6_procentowa_podwyzke
AS 
UPDATE    Agenci
SET          Wynagrodzenie = ROUND(Wynagrodzenie * 1.06, 0);
GO

CREATE VIEW R15_daj_agentom_6_procentowa_podwyzke_zapytanie
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.Wynagrodzenie, Round((Wynagrodzenie)*1.06,0) AS NoweWynagrodzenie
FROM    Agenci;
GO

CREATE PROCEDURE R15_wynagrodz_dobrych_agentow
AS 
UPDATE    Agenci
SET          Premia = Premia + 0.005
WHERE     (IDAgenta IN
            (SELECT     IDAgenta
             FROM          Imprezy
             GROUP BY IDAgenta
             HAVING      SUM(WartoscKontraktu) > 20000));
GO

CREATE VIEW R15_wynagrodz_dobrych_agentow_zapytanie
AS 
SELECT      Premia, Premia + 0.005 AS NowaPremia
FROM   Agenci
WHERE     (IDAgenta IN
            (SELECT     IDAgenta
             FROM          Imprezy
             GROUP BY IDAgenta
             HAVING      SUM(WartoscKontraktu) > 20000));
GO

CREATE PROCEDURE R16_dodaj_klienta
AS 
INSERT INTO Klienci
                      (ImieKlienta, NazwiskoKlienta, AdresKlienta, MiastoKlienta, StanZamKlienta, KodPocztowyKlienta, TelefonKlienta)
VALUES     ('Kendra', 'Hernandez', '457 211th St NE', 'Bothell', 'WA', '98200', '555-3945');
GO

CREATE VIEW R16_dodaj_klienta_zapytanie
AS 
SELECT 'Kendra' As NoweImieKlienta, 'Hernandez' As NoweNazwiskoKlienta, '457 211th St NE' As NowyAdresKlienta, 
   'Bothell' As NoweMiastoKlienta, 'WA' As NowyStanZamKlienta, '98200' As NowyKodPocztowyKlienta, '555-3945' As NowyTelefonKlienta;
GO

CREATE PROCEDURE R16_dodaj_impreze
AS 
INSERT INTO Imprezy
                      (IDKlienta, IDWykonawcy, DzienRozpoczecia, DzienZakonczenia, GodzinaRozpoczecia, GodzinaZakonczenia, WartoscKontraktu, IDAgenta)
SELECT     Klienci.IDKlienta, Wykonawcy.IDWykonawcy, '8/15/2018' AS DzienRozpoczecia, '8/16/2018' AS DzienZakonczenia, '19:00:00' AS GodzinaRozpoczecia, '23:00:00' AS GodzinaZakonczenia, 
                      ROUND(Wykonawcy.StawkaDziennaWykonawcy * 2 * 1.15, 0) AS WartoscKontraktu, Agenci.IDAgenta
FROM         Klienci CROSS JOIN
                      Wykonawcy CROSS JOIN
                      Agenci
WHERE     (Klienci.ImieKlienta = 'Matt') AND (Klienci.NazwiskoKlienta = 'Berg') AND (Wykonawcy.NazwaScenicznaWykonawcy = 'Jazz Persuasion') AND 
                      (Agenci.ImieAgenta = 'Karen') AND (Agenci.NazwiskoAgenta = 'Smith');
GO

CREATE VIEW R16_dodaj_impreze_zapytanie
AS 
SELECT     Klienci.IDKlienta, Wykonawcy.IDWykonawcy, '8/15/2018' AS DzienRozpoczecia, '8/16/2018' AS DzienZakonczenia, '19:00:00' AS GodzinaRozpoczecia, '23:00:00' AS GodzinaZakonczenia, 
                      ROUND(Wykonawcy.StawkaDziennaWykonawcy * 2 * 1.15, 0) AS WartoscKontraktu, Agenci.IDAgenta
FROM         Klienci CROSS JOIN
                      Wykonawcy CROSS JOIN
                      Agenci
WHERE     (Klienci.ImieKlienta = 'Matt') AND (Klienci.NazwiskoKlienta = 'Berg') AND (Wykonawcy.NazwaScenicznaWykonawcy = 'Jazz Persuasion') AND 
                      (Agenci.ImieAgenta = 'Karen') AND (Agenci.NazwiskoAgenta = 'Smith');
GO

CREATE PROCEDURE R16_dodaj_styl
AS 
INSERT INTO Style_muzyczne
                      (NazwaStylu)
VALUES     ('New Age');
GO

CREATE VIEW R16_dodaj_styl_zapytanie
AS
SELECT 'New Age' As NowaNazwaStylu;
GO

CREATE PROCEDURE R16_zarchiwizuj_imprezy
AS 
INSERT INTO Imprezy_archiwum 
         (NumerImprezy, DzienRozpoczecia, DzienZakonczenia, GodzinaRozpoczecia, GodzinaZakonczenia, WartoscKontraktu, 
          IDKlienta, IDAgenta, IDWykonawcy) 
SELECT Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, 
Imprezy.GodzinaRozpoczecia, Imprezy.GodzinaZakonczenia, Imprezy.WartoscKontraktu, Imprezy.IDKlienta, 
Imprezy.IDAgenta, Imprezy.IDWykonawcy
FROM Imprezy
WHERE Imprezy.DzienZakonczenia < '01/01/2018';
GO

CREATE VIEW R16_zarchiwizuj_imprezy_zapytanie
AS 
SELECT Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, 
Imprezy.GodzinaRozpoczecia, Imprezy.GodzinaZakonczenia, Imprezy.WartoscKontraktu, Imprezy.IDKlienta, 
Imprezy.IDAgenta, Imprezy.IDWykonawcy
FROM Imprezy
WHERE Imprezy.DzienZakonczenia < '01/01/2018';
GO

CREATE PROCEDURE R16_skopiuj_agenta_jako_klienta
AS 
INSERT INTO Klienci
                      (ImieKlienta, NazwiskoKlienta, AdresKlienta, MiastoKlienta, StanZamKlienta, KodPocztowyKlienta, TelefonKlienta)
SELECT     ImieAgenta, NazwiskoAgenta, AdresAgenta, MiastoAgenta, StanZamAgenta, KodPocztowyAgenta, TelefonAgenta
FROM         Agenci
WHERE     (ImieAgenta = 'Marianne') AND (NazwiskoAgenta = 'Wier');
GO

CREATE VIEW R16_skopiuj_agenta_jako_klienta_zapytanie
AS 
SELECT     ImieAgenta, NazwiskoAgenta, AdresAgenta, MiastoAgenta, StanZamAgenta, KodPocztowyAgenta, TelefonAgenta
FROM         Agenci
WHERE     (ImieAgenta = 'Marianne') AND (NazwiskoAgenta = 'Wier');
GO

CREATE PROCEDURE R16_powiel_impreze
AS 
INSERT INTO Imprezy
                      (DzienRozpoczecia, DzienZakonczenia, GodzinaRozpoczecia, GodzinaZakonczenia, WartoscKontraktu, IDKlienta, IDAgenta, IDWykonawcy)
SELECT     '8/1/2018' AS DzienRozpoczecia, '8/4/2018' AS DzienZakonczenia, Imprezy.GodzinaRozpoczecia, Imprezy.GodzinaZakonczenia, Imprezy.WartoscKontraktu, 
                      Imprezy.IDKlienta, Imprezy.IDAgenta, Imprezy.IDWykonawcy
FROM         Klienci INNER JOIN
                      Imprezy ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE     (Klienci.ImieKlienta = 'Doris') AND (Klienci.NazwiskoKlienta = 'Hartwig') AND (Imprezy.DzienRozpoczecia = '12/2/2017');
GO

CREATE VIEW R16_powiel_impreze_zapytanie
AS 
SELECT     '8/1/2018' AS DzienRozpoczecia, '8/4/2018' AS DzienZakonczenia, Imprezy.GodzinaRozpoczecia, Imprezy.GodzinaZakonczenia, Imprezy.WartoscKontraktu, 
                      Imprezy.IDKlienta, Imprezy.IDAgenta, Imprezy.IDWykonawcy
FROM         Klienci INNER JOIN
                      Imprezy ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE     (Klienci.ImieKlienta = 'Doris') AND (Klienci.NazwiskoKlienta = 'Hartwig') AND (Imprezy.DzienRozpoczecia = '12/2/2017');
GO

CREATE PROCEDURE R17_usun_klientow_bez_rezerwacji1
AS 
DELETE FROM Gusty_muzyczne
WHERE     (IDKlienta NOT IN
                          (SELECT     IDKlienta
                            FROM          Imprezy));
GO

CREATE VIEW R17_usun_klientow_bez_rezerwacji1_zapytanie
AS 
SELECT * 
FROM Gusty_muzyczne
WHERE     (IDKlienta NOT IN
                          (SELECT     IDKlienta
                            FROM          Imprezy));
GO

CREATE PROCEDURE R17_usun_klientow_bez_rezerwacji2
AS 
DELETE FROM Klienci
WHERE     (IDKlienta NOT IN
                          (SELECT     IDKlienta
                            FROM          Imprezy));
GO

CREATE VIEW R17_usun_klientow_bez_rezerwacji2_zapytanie
AS 
SELECT * 
FROM Klienci
WHERE     (IDKlienta NOT IN
                          (SELECT     IDKlienta
                            FROM          Imprezy));
GO

CREATE PROCEDURE R17_usun_niepopularnych_wykonawcow1
AS 
DELETE FROM Czlonkowie_zespolu
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE VIEW R17_usun_niepopularnych_wykonawcow1_zapytanie
AS 
SELECT * 
FROM Czlonkowie_zespolu
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE PROCEDURE R17_usun_niepopularnych_wykonawcow2
AS 
DELETE FROM Style_wykonawcow
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE VIEW R17_usun_niepopularnych_wykonawcow2_zapytanie
AS 
SELECT * 
FROM Style_wykonawcow
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE PROCEDURE R17_usun_niepopularnych_wykonawcow3
AS 
DELETE FROM Wykonawcy
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE VIEW R17_usun_niepopularnych_wykonawcow3_zapytanie
AS 
SELECT * 
FROM Wykonawcy
WHERE     (IDWykonawcy NOT IN
                          (SELECT     IDWykonawcy
                            FROM          Imprezy));
GO

CREATE PROCEDURE R17_usun_czlonkow_nie_nalezacych_do_zespolu
AS 
DELETE FROM Czlonkowie
WHERE     (IDCzlonka NOT IN
                          (SELECT     IDCzlonka
                            FROM          Czlonkowie_zespolu));
GO

CREATE VIEW R17_usun_czlonkow_nie_nalezacych_do_zespolu_zapytanie
AS 
SELECT * 
FROM Czlonkowie
WHERE     (IDCzlonka NOT IN
                          (SELECT     IDCzlonka
                            FROM          Czlonkowie_zespolu));
GO

CREATE PROCEDURE R17_usun_style_ktorych_nikt_nie_gra
AS 
DELETE FROM Style_muzyczne
WHERE     (IDStylu NOT IN
                          (SELECT     IDStylu
                           FROM          Style_wykonawcow))
      AND (IDStylu NOT IN 
						  (SELECT IDStylu 
						   FROM Gusty_muzyczne));
GO

CREATE VIEW R17_usun_style_ktorych_nikt_nie_gra_zapytanie
AS 
SELECT * 
FROM Style_muzyczne
WHERE     (IDStylu NOT IN
                          (SELECT     IDStylu
                            FROM          Style_wykonawcow))
      AND (IDStylu NOT IN 
						  (SELECT IDStylu 
						   FROM Gusty_muzyczne));
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_imprezy
AS 
DELETE FROM Imprezy
WHERE     (NumerImprezy IN
                          (SELECT     NumerImprezy
                            FROM          Imprezy_archiwum));
GO

CREATE VIEW R17_usun_zarchiwizowane_imprezy_zapytanie
AS 
SELECT * 
FROM Imprezy
WHERE     (NumerImprezy IN
                          (SELECT     NumerImprezy
                            FROM          Imprezy_archiwum));
GO

